
package w83b.w83bUtilidadesComunes;

import java.util.HashMap;

import w83b.w83bManager.W83bCatalogo;
import w83b.xml.datatype.W83bConsultationContext;
import w83b.xml.parser.W83bConsultationContextParser;



public class W83bInformacionProcedimiento implements java.io.Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private HashMap nombreProcedimiento = new HashMap();

	private String idOrganoGestor = "";

	private HashMap nombreOrganoGestor = new HashMap();

	private String idDepartamento = "";

	private HashMap nombreDepartamento = new HashMap();

	private HashMap nombreFamilia = new HashMap();

	private String entidad = "";

	private String procedureId = "";

	private String managingUnitFunction = "";

	private String managingUnitDeliveryKeyFunction = "";

	private String familyID = "";

	private String procedureInboxID = "";

	private String procedureInboxName = "";

	private String certifiedValidationMode = "";

	private String telematicsCode = "";

	private String managingUnitInBoxId = "";

	private String telematicActionId = "";

	private W83bLocaleString telematicActionNameLocale;

	private String userSessionToken = "";

	private HashMap nombreEntidad = new HashMap();
	
	//adaptacion platea v2.1
	private String documentalSeries01Id, documentalSeries20Id, documentalSeries48Id;
	
	private String daProcedureId = "";

	//lo hacemos esttico para no tener que pedir los datos del procedimiento
	// cada vez que los necesitamos. (Habra que reiniciar el servidor si
	// cambian los datos)
	
	
	public W83bInformacionProcedimiento(){
		this.nombreProcedimiento.put("ES","Sindicatos");
        this.nombreProcedimiento.put("EU","Sindicatoak");
		this.idOrganoGestor = "";
		this.nombreOrganoGestor.put("ES","mi casa");
        this.nombreOrganoGestor.put("EU","nire etxea");
		this.idDepartamento = "";
		this.nombreDepartamento.put("ES","Desarrollo");
		this.nombreDepartamento.put("EU","Desarrolloa");
		this.procedureId = "L431";
	}
	
	
	public W83bInformacionProcedimiento(String userSessionToken, String procId)
			throws Exception {
		
		W83bClsTrazas.trazaError(null, " ----- EN W83bInformacionProcedimiento ----- ",new Exception());//NOPMD
		
		//recuperar los datos del catalogo de procedimientos.
		W83bCatalogo catalogo = new W83bCatalogo();
		
		String datosProcedimiento = catalogo.dameDatosProcedimientoAll(
				userSessionToken, procId);

		W83bClsTrazas.trazaError(null, " ----- despues de datosProcedimiento ----- ",new Exception());//NOPMD
		//parsear el resultado
		W83bConsultationContextParser resParser = new W83bConsultationContextParser(
				datosProcedimiento);
		W83bConsultationContext res = resParser.getProcedureDataAll();

		//Nombre del procedimiento en euskera y en castellano
		nombreProcedimiento.put("es".toUpperCase(), res
				.getProcedureNameDesc("es"));
		nombreProcedimiento.put("eu".toUpperCase(), res
				.getProcedureNameDesc("eu"));

		//codigo del organo gestor
		idOrganoGestor = res.getOrganId();

		//descripcion del organo gestor 
		nombreOrganoGestor.put("es".toUpperCase(), res.getOrganNameDesc("es"));
		nombreOrganoGestor.put("eu".toUpperCase(), res.getOrganNameDesc("eu"));

		//codigo del departamento
		idDepartamento = res.getDepartamentId();

		//Descripcin del departamento.
		nombreDepartamento.put("es".toUpperCase(), res
				.getDepartamentNameDesc("es"));
		nombreDepartamento.put("eu".toUpperCase(), res
				.getDepartamentNameDesc("eu"));

		//Familia
		//nombreFamilia.put("es".toUpperCase(),res.getFamilyNameDesc("es"));
		//nombreFamilia.put("eu".toUpperCase(),res.getFamilyNameDesc("eu"));

		//entidad (Habra que recogerlo del getProcedureFac del catlogo de
		// procedimientos)
		entidad = res.getEntityId();

		//Otros datos para el consultationContext
		procedureId = res.getProcedureId();
		//managingUnitFunction = res.getManagingUnitFunction();
		//managingUnitDeliveryKeyFunction = res
		//		.getManagingUnitDeliveryKeyFunction();
		//familyID = res.getFamilyID();
		//procedureInboxID = res.getProcedureInboxID();
		//managingUnitInBoxId = res.getManagingUnitInboxID();
		//procedureInboxName = res.getProcedureInboxName();
		//certifiedValidationMode = res.getCertifiedValidationMode();
		//telematicsCode = res.getTelematicsCode();
		//telematicActionId = res.getTelematicActionId();
		//telematicActionNameLocale = res.getTelematicActionNameLocale();
		//descripcion de la entidad
		//nombreEntidad.put("es".toUpperCase(), res.getEntityNameDesc("es"));
		//nombreEntidad.put("eu".toUpperCase(), res.getEntityNameDesc("eu"));
		
		//adaptacion platea v2.1
		documentalSeries01Id = res.getDocumentalSeries01Id(); 
		documentalSeries20Id = res.getDocumentalSeries20Id(); 
		documentalSeries48Id = res.getDocumentalSeries48Id();
		daProcedureId = res.getDaProcedureId();
		
		W83bClsTrazas.trazaError(null, " ----- salimos de datosProcedimiento ----- ",new Exception());//NOPMD

	}

	public String getNombreProcedimiento(String idioma) {
		return (String) nombreProcedimiento.get(idioma.toUpperCase());
	}

	public String getIdOrganoGestor() {
		return idOrganoGestor;
	}

	public String getNombreOrganoGestor(String idioma) {
		return (String) nombreOrganoGestor.get(idioma.toUpperCase());
	}

	public String getIdDepartamento() {
		return idDepartamento;
	}

	public String getNombreDepartamento(String idioma) {
		return (String) nombreDepartamento.get(idioma.toUpperCase());
	}

	public String getNombreFamilia(String idioma) {
		return (String) nombreFamilia.get(idioma.toUpperCase());
	}

	public String getIdEntidad() {
		return entidad;
	}

	public String getProcedureId() {
		return procedureId;
	}

	public String getManagingUnitInBoxId() {
		return managingUnitInBoxId;
	}

	public String getManagingUnitFunction() {
		return managingUnitFunction;
	}

	public String getManagingUnitDeliveryKeyFunction() {
		return managingUnitDeliveryKeyFunction;
	}

	public String getFamilyID() {
		return familyID;
	}

	public String getProcedureInboxID() {
		return procedureInboxID;
	}

	public String getProcedureInboxName() {
		return procedureInboxName;
	}

	public String getCertifiedValidationMode() {
		return certifiedValidationMode;
	}

	public String getTelematicsCode() {
		return telematicsCode;
	}

	public String getNombreEntidad(String idioma) {
		return (String) nombreEntidad.get(idioma.toUpperCase());
	}

	public void setUserSessionToken(String userSessionTok) {
		this.userSessionToken = userSessionTok;
	}

	public String getUserSessionToken(String userSessionTok) {
		return userSessionToken;
	}
	
	public String getTelematicActionId() {
		return telematicActionId;
	}

	public W83bLocaleString getTelematicActionNameLocale() {
		return telematicActionNameLocale;
	}
	
	public String getDocumentalSeries01Id(){return documentalSeries01Id;}
	public String getDocumentalSeries20Id(){return documentalSeries20Id;}
	public String getDocumentalSeries48Id(){return documentalSeries48Id;}
	public String getDaProcedureId(){return daProcedureId;}

}